/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.security;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWCachedSecurityList;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.uicontrols.security.IVWRecipientSelectionPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class VWRecipientComboPanel
extends JPanel
implements IVWRecipientSelectionPanel,
ItemListener {
    public static final String ACMD_SELECTION_CHANGED = "SelectionChanged";
    private Container m_parentContainer = null;
    private VWSession m_vwSession = null;
    private EventListenerList m_listenerList = null;
    private JComboBox m_recipientsComboBox = null;

    public VWRecipientComboPanel(Container parentContainer, VWSession vwSession) {
        this.m_parentContainer = parentContainer;
        this.m_vwSession = vwSession;
        this.m_listenerList = new EventListenerList();
        this.init();
    }

    public JComboBox getRecipientFilterJComboBox() {
        return this.m_recipientsComboBox;
    }

    public void addActionListener(ActionListener listener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.add(ActionListener.class, listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.remove(ActionListener.class, listener);
        }
    }

    public int getItemCount() {
        if (this.m_recipientsComboBox != null) {
            return this.m_recipientsComboBox.getModel().getSize();
        }
        return -1;
    }

    public VWParticipant getSelectedValue() {
        Object value;
        if (this.m_recipientsComboBox != null && (value = this.m_recipientsComboBox.getSelectedItem()) != null && value instanceof VWParticipantItem) {
            return ((VWParticipantItem)value).getVWParticipant();
        }
        return null;
    }

    public void setSelectedValue(VWParticipant recipient) {
        if (this.m_recipientsComboBox != null && recipient != null) {
            boolean bFound = false;
            if (this.getItemCount() > 0) {
                for (int i = 0; i < this.getItemCount(); ++i) {
                    VWParticipantItem participantItem = this.getItemAt(i);
                    if (participantItem == null || VWStringUtils.compare(participantItem.getShortName(), recipient.getParticipantName()) != 0) continue;
                    this.setSelectedIndex(i);
                    bFound = true;
                    break;
                }
            }
            if (!bFound) {
                DefaultListModel listModel = (DefaultListModel)((Object)this.m_recipientsComboBox.getModel());
                VWParticipantItem newItem = new VWParticipantItem(recipient);
                listModel.addElement(newItem);
                this.m_recipientsComboBox.setSelectedItem(newItem);
            }
        }
    }

    public boolean hasValidSelection() {
        return this.getSelectedIndex() > 0;
    }

    public void setEnabled(boolean bEnable) {
        if (this.m_recipientsComboBox != null) {
            this.m_recipientsComboBox.setEnabled(bEnable);
        }
    }

    public void reset() {
        this.setSelectedIndex(0);
    }

    public void removeReferences() {
        if (this.m_recipientsComboBox != null) {
            this.m_recipientsComboBox.removeItemListener(this);
            this.m_recipientsComboBox = null;
        }
        this.m_parentContainer = null;
        this.m_vwSession = null;
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getSource().equals(this.m_recipientsComboBox) && event.getStateChange() == 1) {
            this.fireActionEvent(ACMD_SELECTION_CHANGED);
        }
    }

    private void init() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(4, 4, 4, 4);
            gbCons.ipadx = 0;
            gbCons.ipady = 0;
            this.m_recipientsComboBox = new JComboBox(this.getUsers());
            this.m_recipientsComboBox.setName("m_recipientsComboBox_VWRecipientComboPanel");
            this.m_recipientsComboBox.addItemListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_recipientsComboBox, this, VWResource.s_recipientsComboBox, VWResource.s_recipientsComboBox);
            this.add((Component)this.m_recipientsComboBox, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            this.add((Component)new JLabel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWParticipantItem getItemAt(int nIndex) {
        Object item;
        if (this.m_recipientsComboBox != null && this.getItemCount() > nIndex && (item = this.m_recipientsComboBox.getModel().getElementAt(nIndex)) != null && item instanceof VWParticipantItem) {
            return (VWParticipantItem)item;
        }
        return null;
    }

    private int getSelectedIndex() {
        if (this.m_recipientsComboBox != null && this.getItemCount() > 0) {
            return this.m_recipientsComboBox.getSelectedIndex();
        }
        return -1;
    }

    private void setSelectedIndex(int nIndex) {
        if (this.m_recipientsComboBox != null && this.getItemCount() > nIndex) {
            this.m_recipientsComboBox.setSelectedIndex(nIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultComboBoxModel getUsers() {
        DefaultComboBoxModel<Object> cbModel = new DefaultComboBoxModel<Object>();
        if (this.m_parentContainer != null) {
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            cbModel.addElement(VWResource.s_selectAPerson);
            VWParticipantItem[] userList = VWCachedSecurityList.getUsersParticipant(this.m_vwSession);
            if (userList != null) {
                for (int i = 0; i < userList.length; ++i) {
                    cbModel.addElement(userList[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(JOptionPane.getFrameForComponent(this.m_parentContainer), ex.getLocalizedMessage(), 1);
        }
        finally {
            if (this.m_parentContainer != null) {
                this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return cbModel;
    }

    private void fireActionEvent(String actionCommand) {
        ActionEvent event = new ActionEvent(this, 1001, actionCommand);
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }
}

